<?php

if (!defined('ABSPATH')) {
    exit();
}
class CMC_Single_Shortcode
{
/*
|--------------------------------------------------------------------------
| bootstraping all shortcodes and all required methods
|--------------------------------------------------------------------------
 */
    public function __construct()
    {

        if (!is_admin()) {

            add_action('wp_enqueue_scripts', array($this, 'cmc_single_assets'));
            add_filter('body_class', array($this, 'cmc_add_class_to_body_tag'), 10, 1);

            /*
            Features based Shortcode for coin single page
             */
            // exchange main basic info handler
            add_shortcode('coin-market-cap-details', array($this, 'cmc_coin_details'));
            // dynamic description
            add_shortcode('coin-market-cap-description', array($this, 'cmc_description'));
            add_shortcode('cmc-dynamic-description', array($this, 'cmc_dynamic_description'));
            add_shortcode('cmc-dynamic-title', array($this, 'cmc_dynamic_title'));
            add_shortcode('coin-market-cap-comments', array($this, 'cmc_comment_box'));
            add_shortcode('cmc-chart', array($this, 'cmc_chart_shortcode'));
            add_shortcode('cmc-twitter-feed', array($this, 'cmc_twitter_feed'));
            add_shortcode('cmc-history', array($this, 'cmc_historical_data'));
            add_shortcode('cmc-coin-extra-data', array($this, 'cmc_coin_extra_data'));
            add_shortcode('cmc-prediction', array($this, 'cmc_coin_pediction'));
            add_shortcode('cmc-affiliate-link', array($this, 'cmc_affiliate_links'));
            add_shortcode('cmc-24h-high-low-price', array($this, 'cmc_24h_high_low_price'));
            add_filter('the_title', array($this, 'cmc_custom_page_title'), 10, 2);

            add_shortcode('cmc-coin-name', array($this, 'cmc_coin_name_shortcode'));
        }

        add_filter('pre_get_document_title', array($this, 'cmc_add_coin_name_to_title'), 10, 1);
        add_action('wp_head', array($this, 'cmc_custom_meta_des'), 5);
        //seopress filters
        add_filter('seopress_titles_title', array($this, 'cmc_add_coin_name_to_title'));
        add_filter('seopress_titles_desc', array($this, 'cmc_open_graph_desc'));
        /* RankMAth Filter hooks */
        add_filter('rank_math/frontend/title', array($this, 'cmc_add_coin_name_to_title'));
        add_filter('rank_math/frontend/description', array($this, 'cmc_open_graph_desc'));
        add_filter('rank_math/frontend/canonical', array($this, 'set_custom_canonical_url'));
        /* Yoast Filter hooks */
        add_filter('wpseo_title', array($this, 'cmc_add_coin_name_to_title'), 10, 1);
        add_filter('wpseo_opengraph_url', array($this, 'yoast_og_url'), 10, 1);
        add_filter('wpseo_opengraph_title', array($this, 'cmc_add_coin_name_to_title'), 10, 1);
        add_filter('wpseo_metadesc', array($this, 'cmc_open_graph_desc'), 10, 1);
        add_filter('wpseo_opengraph_desc', array($this, 'cmc_open_graph_desc'), 10, 1);
        add_action('wp', array($this, 'remove_canonical')); //After WP object is

        add_action('plugins_loaded', array($this, 'cmc_load_calculator'));

        add_action('wp_ajax_nopriv_cmc_coin_chart', array($this, 'cmc_coin_historical_callback'));
        add_action('wp_ajax_cmc_coin_chart', array($this, 'cmc_coin_historical_callback'));
    }

    /*
    |--------------------------------------------------------------------------
    | coin 24h high low data slider
    |--------------------------------------------------------------------------
     */

    public function cmc_24h_high_low_price()
    {
        $output = "";

        if (get_query_var('coin_id')) {
            //changed to coin name
            $btc_price = 0;
            //  $api_obj=new CMC_api_data();
            $coin_id = (string) trim(get_query_var('coin_id'));
            $real_cur = get_query_var('currency');
            $single_default_currency = cmc_get_option('default_currency');
            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;

            $currency_icon = cmc_old_cur_symbol($old_currency);
            $fiat_c_rate = CMC_api_data::cmc_usd_conversions($old_currency);
            if ($old_currency == "BTC") {
                $btc_price = cmc_btc_price();

            }
            //grabing data from DB
            $coin = cmc_get_coin_details($coin_id);
            if ($coin) {

                if (!empty($coin['price'])) {
                    $price = ($old_currency == "BTC") ? $coin['price'] / $btc_price : $coin['price'] * $fiat_c_rate;
                    $coin_price = cmc_formatNumberWithDynamicDecimals($price);
                }else{
                    $coin_price = __('N/A', 'cmc');
                }
                if (!empty($coin['high_24h'])) {
                    $high_24h_val = ($old_currency == "BTC") ? $coin['high_24h'] / $btc_price : $coin['high_24h'] * $fiat_c_rate;

                    $high_24h = cmc_formatNumberWithDynamicDecimals($high_24h_val);

                } else {
                    $high_24h = '';
                }
                if (!empty($coin['low_24h'])) {
                    $low_24h_val = ($old_currency == "BTC") ? $coin['low_24h'] / $btc_price : $coin['low_24h'] * $fiat_c_rate;

                    $low_24h = cmc_formatNumberWithDynamicDecimals($low_24h_val);

                } else {
                    $low_24h = '';
                }

                $single_live_updates = $this->cmc_single_page_setting('single_live_updates');
                $live_updates_cls = "";
                if ($single_live_updates) {
                    $live_updates_cls = "cmc_live_updates";
                }
                if ($this->cmc_single_page_setting("display_high_24h_single")) {
                    $output .= '<div class="cmc-slidecontainer">
                        <span class="cmc-lowlabel">Low 24H: ' . esc_html($currency_icon . '' . $low_24h) . '</span>
                        <input type="range" id ="cmc-price-range" class="single_lU_wrp ' . esc_attr($live_updates_cls) . ' cmc_coin_price coin-price" min="' . esc_attr($low_24h_val) . '" max="' . esc_attr($high_24h_val) . '" value="' . esc_attr($price) . '" step="0.00000001" disabled>
                        <span class="cmc-highlabel">High 24H: ' . esc_html($currency_icon . '' . $high_24h) . '</span>
                    </div>';
                }

                return $output;

            }
        }
    }

    public function yoast_og_url()
    {
        $coin_symbol = get_query_var('coin_symbol');
        $coin_id = trim(get_query_var('coin_id'));
        global $post, $wp;
        $single_page_id = get_option('cmc-coin-advanced-single-page-id'); //get_option('cmc-coin-single-page-id');
        if ($post == null || $post->ID != $single_page_id) {
            return;
        }

        $single_page_slug = cmc_get_page_slug();
        $coin_url = esc_url(home_url($single_page_slug . '/' . $coin_symbol . '/' . $coin_id . '/', '/'));
        $desc = $this->cmc_generate_desc($position = "top");
        $meta_des = esc_html($desc);

        $current_page = home_url($wp->request);
        $site_name = get_bloginfo('name');
        echo '<meta property="og:url" content="' . esc_attr($current_page) . '"/>';

    }

    /*
    |-------------------------------------------------------------------|
    | Set Custom canonical URL on coins single page for SEO             |
    |-------------------------------------------------------------------|
     */
    public function set_custom_canonical_url($canonical)
    {
        //get current page ID
        global $post, $wp;

        // fetch advance layout page id
        $single_page_id = get_option('cmc-coin-single-page-id');
        if ($post && $post->ID == $single_page_id) {

            //get current page dynamic details
            $coin_symbol = get_query_var('coin_symbol');
            $coin_id = trim(get_query_var('coin_id'));
            $single_page_slug = cmc_get_page_slug();
            $canonical = esc_url(home_url($single_page_slug . '/' . $coin_symbol . '/' . $coin_id . '/', '/'));

        }

        return $canonical;
    }

    /*
    |--------------------------------------------------------------------------
    | Rank math canonical
    |--------------------------------------------------------------------------
     */
    public function rankmath_canonical_url()
    {
        $coin_symbol = get_query_var('coin_symbol');
        $coin_id = trim(get_query_var('coin_id'));
        global $post, $wp;
        $single_page_id = get_option('cmc-coin-single-page-id'); //get_option('cmc-coin-single-page-id');
        if ($post == null || $post->ID != $single_page_id) {
            return;
        }

        $single_page_slug = cmc_get_page_slug();
        $coin_url = esc_url(home_url($single_page_slug . '/' . $coin_symbol . '/' . $coin_id . '/', '/'));
        $desc = $this->cmc_generate_desc($position = "top");
        $meta_des = esc_html($desc);

        $current_page = home_url($wp->request);
        $site_name = get_bloginfo('name');
        echo '<meta property="og:url" content="' . esc_attr($current_page) . '"/>
        <meta property="og:site_name" content="' . esc_attr($site_name) . '"/>';

        if (isset($coin_id)) {
            $logo = coin_logo_url($coin_id);
            if (isset($logo['logo'])) {
                $logo_path = $logo['logo'];
                echo '<meta property="og:image" content="' . esc_attr($logo_path) . '"/>';
            }
        }

        echo '
           <link rel="canonical" href="' . $coin_url . '" />';
    }
    /*
    |-------------------------------------------------------------------|
    |   Add a custom class to the HTML body tag,                        |
    |   only if current page is selected coin details page              |
    |-------------------------------------------------------------------|
     */
    public function cmc_add_class_to_body_tag($classes)
    {

        global $post;
        if (isset($post->ID) && $post->ID == get_option('cmc-coin-single-page-id')) {
            return array_merge($classes, array('cmc-single-page'));
        }
        return $classes;
    }

/*
|--------------------------------------------------------------------------
| Ajax Callback handler for coin chart and historical table
|--------------------------------------------------------------------------
 */
    public function cmc_coin_historical_callback()
    {
        // 1. Sanitize and escape user input from a form. Assume the input comes from $_POST['user_input'].
        $nonce = sanitize_text_field($_POST['_wpnonce']);
        if (!wp_verify_nonce($nonce, 'wp_rest')) {
            $response = array('error' => 'nonce_failed');

            echo json_encode($response);
            wp_die();

        }

        $meta_tbl = new CMC_Coins_historical();
        // 2. Sanitize and escape a URL provided in $_POST['url_input'].
        $coin_symbol = !empty($_POST['symbol']) ? sanitize_text_field($_POST['symbol']) : "";
        $type = !empty($_POST['type']) ? sanitize_text_field($_POST['type']) : "";
        $clicked = !empty($_POST['click_days']) ? sanitize_text_field($_POST['click_days']) : "";
        $historical_data1 = get_transient("cmc-" . $coin_symbol . '-history-data-24H');
        $historical_data365 = get_transient("cmc-" . $coin_symbol . '-history-data-365');
        $day = isset($_POST['day']) ? absint($_POST['day']) : 365; // 3. Sanitize a number provided in $_POST['number_input'] using absint().
        $transient = ($day == 2) ? $historical_data1 : $historical_data365;

        if ($type == "chart") {
            $resposne['status'] = 'success';

            if ($clicked == 'false' && cmc_get_option('enable_7day_chart') != 'on') {
                // 5. Sanitize user input for a database query and use $wpdb->prepare() for insertion.
                $resposne['data'] = cmc_get_7day_chart($coin_symbol);
                if (empty($resposne['data'])) {
                    $resposne['data'] = (false == $transient) ? cmc_historical_chart_json($coin_symbol, 365) : $meta_tbl->cmc_get_historical_data($coin_symbol, 365);
                }

            } else {
                $resposne['data'] = (false == $transient) ? cmc_historical_chart_json($coin_symbol, $day) : $meta_tbl->cmc_get_historical_data($coin_symbol, $day);
            }
            echo json_encode($resposne);
        } else {
            $resposne['data'] = (false == $transient) ? cmc_historical_chart_json($coin_symbol, $day) : $meta_tbl->cmc_get_historical_data($coin_symbol, $day);
            if (isset($resposne['data'])) {
                array_pop($resposne['data']);
            }
            echo json_encode($resposne);
        }
        wp_die();
    }

/*
|--------------------------------------------------------------------------
|Remove - Canonical from - [cmc currency details - Page]
|--------------------------------------------------------------------------
 */
    public function remove_canonical()
    {
        global $post;
        $single_page_id = get_option('cmc-coin-single-page-id');
        if ($post == null) {
            return;
        }
        if (is_page('cmc-currency-details') || is_page('cmc-currency-details-advanced-design') || $post->ID == $single_page_id) {
            add_filter('wpseo_canonical', '__return_false', 10, 1);
        }
    }

/*
|--------------------------------------------------------------------------
|  Single Page URL Bar Title
|--------------------------------------------------------------------------
 */
    public function cmc_add_coin_name_to_title($cmc_title)
    {
        global $post;
        $single_page_id = get_option('cmc-coin-single-page-id');
        if ($post == null) {
            return;
        }
        if ($post->ID == $single_page_id) {
            $cmc_title = $this->cmc_generate_title($position = 'top');
        }
        /* Return the title. */
        return $cmc_title;
    }
/*
|--------------------------------------------------------------------------
|  Single Page Title
|--------------------------------------------------------------------------
 */
    public function cmc_custom_page_title($title, $id = null)
    {
        $single_page_id = get_option('cmc-coin-single-page-id');
        if ($id == $single_page_id) {
            $title = $this->cmc_generate_title($position = 'default');
        }
        return $title;
    }

/*
|--------------------------------------------------------------------------
| load calculator shortcode
|--------------------------------------------------------------------------
 */
    public function cmc_load_calculator()
    {
        //calculator
        require_once 'cmc-calculator.php';
        add_shortcode('cmc-calculator', 'cmc_calculator');
    }
/*
|--------------------------------------------------------------------------
| Yoast open tag description
|--------------------------------------------------------------------------
 */
    public function cmc_open_graph_desc($desc)
    {
        $single_page_id = get_option('cmc-coin-single-page-id');
        if (is_page($single_page_id)) {
            return $desc = $this->cmc_generate_desc($position = "top");

        }
        return $desc;
    }

/*
|--------------------------------------------------------------------------
| Display custom meta description
|--------------------------------------------------------------------------
 */

    public function cmc_custom_meta_des()
    {

        // coin detail page meta desc
        global $post;
        if ($post == null) {
            return;
        }
        $single_page_id = get_option('cmc-coin-single-page-id');
        if ($post->ID == $single_page_id && !class_exists('RankMath')) {
            $coin_symbol = !empty(get_query_var('coin_symbol')) ? get_query_var('coin_symbol') : 'BTC';
            $coin_name = !empty(trim(get_query_var('coin_id'))) ? trim(get_query_var('coin_id')) : 'bitcoin';

            if ($coin_symbol == null || $coin_name == null) {
                return;
            }
            global $wp;
            $single_page_slug = cmc_get_page_slug();
            $coin_url = esc_url(home_url($single_page_slug . '/' . $coin_symbol . '/' . $coin_name, '/'));
            $desc = $this->cmc_generate_desc($position = "top");
            $meta_des = esc_html($desc);
            echo '<link rel="canonical" href="' . $coin_url . '" />';

            if (!defined('WPSEO_VERSION')) {
                echo '<meta name="description" content="' . $meta_des . '"/>';
                echo '<meta property="og:description" content="' . $meta_des . '"/>';
                echo '<meta property="og:title" content="' . esc_attr(get_the_title()) . '"/>';

                $current_page = home_url($wp->request);

                echo '<meta property="og:type" content="article"/>';
                echo '<meta property="og:url" content="' . esc_attr($current_page) . '"/>';
                $site_name = get_bloginfo('name');
                // Customize the below with the name of your site
                echo '<meta property="og:site_name" content="' . esc_attr($site_name) . '"/>';
                $coin_id = (string) $coin_name;
                if (isset($coin_id)) {
                    $logo = coin_logo_url($coin_id);
                    if (isset($logo['logo'])) {
                        $logo_path = $logo['logo'];
                        echo '<meta property="og:image" content="' . esc_attr($logo_path) . '"/>';

                    }
                }
            }
        }

    }

/*
|--------------------------------------------------------------------------
|Dynamic Title shortcode
|--------------------------------------------------------------------------
 */
    public function cmc_coin_name_shortcode($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'type' => 'name',
        ), $atts);
        $output = '';
        if (get_query_var('coin_id')) {
            $coin_id = (string) trim(get_query_var('coin_id'));
            $coin_symbol = (string) trim(get_query_var('coin_symbol'));
            $name = str_replace("-", " ", $coin_id);
            $type = trim($atts['type']) == '' ? 'name' : trim($atts['type']);

            switch ($type) {
                case "symbol":
                    $output .= '<span class="cmc-coin-symbol">' . esc_html($coin_symbol) . '</span>';
                    break;
                default:
                case "name":
                    $output .= '<span class="cmc-coin-name">' . esc_html(ucwords($name)) . '</span>';
                    break;
            }

        }
        return $output;
    }
    /*
     * This function is used to show coin price prediction in single page
     */
    public function cmc_coin_pediction($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'percentage' => '5',
            'movement' => 'up',
            'id' => '',
        ), $atts);
        $output = '';
        $predi_per = isset($atts['percentage']) ? $atts['percentage'] : '';
        $movement = isset($atts['movement']) ? $atts['movement'] : '';
        $id = isset($atts['id']) ? $atts['id'] : '';
        if (get_query_var('coin_id') || $id != '') {
            $cid = (string) trim(get_query_var('coin_id'));
            $coin_id = !empty($cid) ? $cid : $id;
            $real_cur = get_query_var('currency');
            $single_default_currency = cmc_get_option('default_currency');
            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
            $currency_icon = cmc_old_cur_symbol($old_currency);
            $coin = cmc_get_coin_details($coin_id);
            if ($coin) {
                $price = $coin['price'];
                $coin_price = cmc_formatNumberWithDynamicDecimals($price);
            }else{
                $coin_price = __('N/A', 'cmc');
            }
            if ($movement == 'up') {
                $final_price = $price + $price * $predi_per / 100;
            } else {
                $final_price = $price - $price * $predi_per / 100;
            }
            $output = $currency_icon . format_number($final_price);
        }
        return $output;
    }
/*
|--------------------------------------------------------------------------
|Dynamic description for SEO
|--------------------------------------------------------------------------
 */
    public function cmc_dynamic_description($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';

        $desc = $this->cmc_generate_desc($position = "default");
        $output .= '<div class="cmc_dynamic_description"><p>
             ' . $desc . '</p></div>';
        return $output;
    }

/*
|--------------------------------------------------------------------------
| generating coin dynamic description
|--------------------------------------------------------------------------
 */

    public function cmc_generate_desc($position)
    {
        $desc = '';
        $dynamic_desciption = cmc_get_option('dynamic_desciption');
        $enable_formatting = cmc_get_option('s_enable_formatting');
        if (get_query_var('coin_id')) {
            //changed to coin name
            $btc_price = 0;
            //  $api_obj=new CMC_api_data();
            $coin_id = (string) trim(get_query_var('coin_id'));
            $real_cur = get_query_var('currency');
            $single_default_currency = cmc_get_option('default_currency');
            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
            $currency_icon = cmc_old_cur_symbol($old_currency);
            $fiat_c_rate = CMC_api_data::cmc_usd_conversions($old_currency);
            if ($old_currency == "BTC") {
                $btc_price = cmc_btc_price();

            }
            //grabing data from DB
            $coin = cmc_get_coin_details($coin_id);
            if ($coin) {
                $coin_symbol = $coin['symbol'];
                $coin_name = $coin['name'];
                $supply = $coin["circulating_supply"];
                if (!empty($coin['price'])) {
                    $price = ($old_currency == "BTC") ? $coin['price'] / $btc_price : $coin['price'] * $fiat_c_rate;
                    $coin_price = cmc_formatNumberWithDynamicDecimals($price);
                }else{
                    $coin_price = __('N/A', 'cmc');
                }
                $market_cap = '';
                if (isset($coin['market_cap']) && $coin['market_cap'] > 0.00) {
                    $market_cap = ($old_currency == "BTC") ? $coin['market_cap'] / $btc_price : $coin['market_cap'] * $fiat_c_rate;
                    if ($enable_formatting) {
                        $market_cap = $currency_icon . cmc_format_coin_values($market_cap);
                    } else {
                        $market_cap = $currency_icon . format_number($market_cap);
                    }
                } else {
                    $market_cap = __('N/A', 'cmc');
                }

                $change_sign_minus = "-";
                $change_lbl = '';
                if (strpos($coin['percent_change_24h'], $change_sign_minus) !== false) {
                    $change_lbl = __('down', 'cmc');
                } else {
                    $change_lbl = __('up', 'cmc');
                }
                $changes = number_format((float)$coin['percent_change_24h'], 2, '.', '') . '%';
                $symbol = $coin_symbol;
                $dynamic_array = array($coin_name, $symbol, $currency_icon . $coin_price, $market_cap, $changes . ' ' . $change_lbl);
                $placeholders = array('[coin-name]', '[coin-symbol]', '[coin-price]', '[coin-marketcap]', '[coin-changes]');
                $desc = str_replace($placeholders, $dynamic_array, $dynamic_desciption);
            }
            return do_shortcode($desc);
        }

    }

/*
|--------------------------------------------------------------------------
| Dynamic Title for SEO
|--------------------------------------------------------------------------
 */
    public function cmc_dynamic_title($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';
        $desc = '';
        $title_txt = $this->cmc_generate_title($position = 'default');
        $output = '<h1 class="cmc-dynamic-title">' . esc_html($title_txt) . '</h1>';
        return $output;
    }

/*
|--------------------------------------------------------------------------
| Coin custom dynamic title from plugin settings panel
| Shortcode:-[cmc-dynamic-title]
|--------------------------------------------------------------------------
 */
    //creating dynamic title
    public function cmc_generate_title($position)
    {
        $title_txt = '';
        if (get_query_var('coin_id')) {
            $btc_price = 0;

            $dynamic_title = !empty(cmc_get_option('dynamic_title')) ? cmc_get_option('dynamic_title') : '[coin-name] current price is [coin-price].';
            $single_default_currency = cmc_get_option('default_currency');
            $enable_formatting = cmc_get_option('s_enable_formatting');
            $coin_id = (string) trim(get_query_var('coin_id'));
            $real_cur = get_query_var('currency');
            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
            // $api_obj=new CMC_api_data();
            $currency_icon = cmc_old_cur_symbol($old_currency);
            $fiat_c_rate = CMC_api_data::cmc_usd_conversions($old_currency);
            if ($old_currency == "BTC") {
                $btc_price = cmc_btc_price();

            }
            //grabing data from DB
            $coin = cmc_get_coin_details($coin_id);
            if ($coin) {
                $coin_symbol = $coin['symbol'];
                $coin_name = $coin['name'];
                $supply = $coin["circulating_supply"];
                $market_cap = $coin["market_cap"];

                if (!empty($coin['price'])) {
                    $price = ($old_currency == "BTC") ? $coin['price'] / $btc_price : $coin['price'] * $fiat_c_rate;
                    $coin_price = cmc_formatNumberWithDynamicDecimals($price);
                }else{
                    $coin_price = __('N/A', 'cmc');
                }

                $market_cap = '';
                if (isset($coin['market_cap'])) {
                    $market_cap = ($old_currency == "BTC") ? $coin['market_cap'] / $btc_price : $coin['market_cap'] * $fiat_c_rate;
                    if ($enable_formatting) {
                        $market_cap = $currency_icon . cmc_format_coin_values($market_cap);
                    } else {
                        $market_cap = $currency_icon . format_number($market_cap);
                    }
                } else {
                    $market_cap = __('N/A', 'cmc');
                }

                $change_sign_minus = "-";
                $change_lbl = '';
                if (strpos($coin['percent_change_24h'], $change_sign_minus) !== false) {
                    $change_lbl = __('down', 'cmc');
                } else {
                    $change_lbl = __('up', 'cmc');
                }
                $changes = $coin['percent_change_24h'] . '%';
                $symbol = $coin_symbol;
                $dynamic_array = array($coin_name, $symbol, $currency_icon . $coin_price, $market_cap, $changes . ' ' . $change_lbl);
                $placeholders = array('[coin-name]', '[coin-symbol]', '[coin-price]', '[coin-marketcap]', '[coin-changes]');
                $title_txt = str_replace($placeholders, $dynamic_array, $dynamic_title);
            }
            return $title_txt;
        }
    }

/*
|--------------------------------------------------------------------------
| Coin custom dynamic description from plugin settings panel
| Shortcode:-[cmc-dynamic-description]
|--------------------------------------------------------------------------
 */

    public function cmc_description($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);

        $output = '';

        $description = '';
        $display_api_desc = cmc_get_option('display_api_desc');
        if (get_query_var('coin_id')) {
            $coin_id = (string) trim(get_query_var('coin_id'));

            if ($display_api_desc) {
                $dbDescription = cmc_get_coin_desc($coin_id);
                if ($dbDescription !== false) {
                    $description = $dbDescription;
                }
            }

            // The Query
            $query = array('post_type' => 'cmc-description', 'meta_value' => $coin_id);
            $the_query = new WP_Query($query);
            // The Loop
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    $cmcd_id = get_the_ID();
                    //$meta = get_post_meta($cmcd_id, 'cmc_single_settings_coin_description_editor', true);
                    $meta = cmc_get_wysiwyg_output('cmc_single_settings_coin_description_editor', $cmcd_id);
                }
                /* Restore original Post Data*/
                wp_reset_postdata();
            }

            $coin_desc = !empty($meta) ? $meta : $description;
            if ($coin_desc != '') {
                $read_more = __('Read More', 'cmc');
                $read_less = __('Read Less', 'cmc');
                $enable_hide_show = cmc_get_option('cmc_readmore_length');
                // $output .= '<div class="cmc-coin-info">' . $coin_desc . '</div>';
                $maxWords = 150;

                $wordsArray = str_word_count($coin_desc, 1);

                if (isset($enable_hide_show) && $enable_hide_show == "yes" && count($wordsArray) > $maxWords) {
                    wp_enqueue_script('cmc-readmore-option');
                    $limitedString = implode(' ', array_slice($wordsArray, 0, $maxWords)) . "...";
                    $limitedString .= ' <a href="#" class="cmc-read-more-link">' . esc_html($read_more) . '</a>';
                    $output .= '<div class="cmc-limited-text">' . wp_kses_post($limitedString) . '</div>';
                    $output .= '<div class="cmc-full-text" style="display: none;">' . wp_kses_post($coin_desc) . ' <a href="#" class="cmc-read-less-link">' . esc_html($read_less) . '</a></div>';

                } else {
                    $output .= '<div class="cmc_custom_description">' . wp_kses_post($coin_desc) . '</div>';
                }
            }
        }
        return $output;
    }

/*
|--------------------------------------------------------------------------
| Coin main information handler shortcode
| Shortcode:-[coin-market-cap-details]
|--------------------------------------------------------------------------
 */
    public function cmc_coin_details($atts, $content = null)
    {
        // shortcode
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts, 'cmc');
        $output = '';
        global $wpdb;
        $table = $wpdb->base_prefix . CMC_DB;
        $coin_id = trim(get_query_var('coin_id'));
        $result = $wpdb->get_results("SELECT coin_id FROM {$table} ORDER BY market_cap DESC, total_volume DESC");

        $result = objectToArray($result);
        $rank = 'N/A';
        $coin_rank = 1;

        foreach ($result as $coins) {

            if (strcasecmp($coin_id, trim($coins['coin_id'])) === 0) {
                $rank = $coin_rank;
                break;
            }
            $coin_rank++;
        }
        $post_id = get_option('cmc-post-id');
        $coin_released = '365day';

        if (get_query_var('coin_id')) {
            // changed from symbol to name based
            $btc_price = 0;
            $coin_id = (string) trim(get_query_var('coin_id'));
            $coin = cmc_get_coin_details($coin_id);
            $real_cur = get_query_var('currency');
            $single_default_currency = cmc_get_option('default_currency');
            $enable_formatting = cmc_get_option('s_enable_formatting');
            $single_live_updates = cmc_get_option('single_live_updates');

            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
            // $api_obj=new CMC_api_data();
            $fiat_c_rate = CMC_api_data::cmc_usd_conversions($old_currency);
            $currency_symbol = cmc_old_cur_symbol($old_currency);
            if ($old_currency == "BTC") {
                $btc_price = cmc_btc_price();

            }
            if ($coin) {
                //$mainId = $coin['id'];
                $coin_symbol = $coin['symbol'];
                $coin_name = $coin['name'];
                $currency_icon = cmc_old_cur_symbol($old_currency);
                $coin_ath = '';
                $high_24h_val = '';
                $ath_change_percentage = '';
                $ath_date = '';
                $low_24h_val = '';
                $percent_change_24h = number_format((float)$coin['percent_change_24h'], 2, '.', '') . '%';
                $supply = $coin["circulating_supply"];

                if (!empty($coin['price'])) {
                    $price = ($old_currency == "BTC") ? $coin['price'] / $btc_price : $coin['price'] * $fiat_c_rate;
                    $coin_price = cmc_formatNumberWithDynamicDecimals($price);
                }else{
                    $coin_price = __('N/A', 'cmc');
                }
                if (!empty($coin['ath'])) {
                    $coin_ath = ($old_currency == "BTC") ? $coin['ath'] / $btc_price : $coin['ath'] * $fiat_c_rate;
                    $ath = $currency_icon . cmc_formatNumberWithDynamicDecimals($coin_ath);

                } else {
                    $ath = "N/A";
                }
                if (!empty($coin['high_24h'])) {
                    $high_24h_val = ($old_currency == "BTC") ? $coin['high_24h'] / $btc_price : $coin['high_24h'] * $fiat_c_rate;
                    $high_24h = $currency_icon . cmc_formatNumberWithDynamicDecimals($high_24h_val);

                } else {
                    $high_24h = "N/A";
                }
                if (!empty($coin['low_24h'])) {
                    $low_24h_val = ($old_currency == "BTC") ? $coin['low_24h'] / $btc_price : $coin['low_24h'] * $fiat_c_rate;
                    $low_24h = $currency_icon . cmc_formatNumberWithDynamicDecimals($low_24h_val);

                } else {
                    $low_24h = "N/A";
                }

                if (isset($coin['ath_date']) && $coin['ath_date'] > 0.00 && $coin['ath_date'] != '0000-00-00 00:00:00') {
                    $str = substr($coin['ath_date'], 0, strrpos($coin['ath_date'], ' '));
                    $ath_date = $str;

                }
                if (isset($coin['total_volume'])) {
                    $volume = ($old_currency == "BTC") ? $coin['total_volume'] / $btc_price : $coin['total_volume'] * $fiat_c_rate;
                    if ($enable_formatting) {
                        $volume = cmc_format_coin_values($volume);
                    } else {
                        $volume = format_number($volume);
                    }
                } else {
                    $volume = __('N/A', 'cmc');
                }

                $market_cap = '';
                if (isset($coin['market_cap']) && $coin['market_cap'] > 0.00) {
                    $market_cap = ($old_currency == "BTC") ? $coin['market_cap'] / $btc_price : $coin['market_cap'] * $fiat_c_rate;
                    if ($enable_formatting) {
                        $market_cap = $currency_icon . cmc_format_coin_values($market_cap);
                    } else {
                        $market_cap = $currency_icon . format_number($market_cap);
                    }
                } else {
                    $market_cap = __('N/A', 'cmc');
                }
                if ($supply && $supply > 0.00) {
                    if ($enable_formatting) {
                        $available_supply = cmc_format_coin_values($supply);
                    } else {
                        $available_supply = number_format($supply);
                    }
                } else {
                    $available_supply = __('N/A', 'cmc');
                }

                $change_sign = '<i class="cmc_icon-up" aria-hidden="true"></i>';
                $change_class = 'cmc-up';
                $change_sign_minus = "-";
                $change_sign_24h = '<i class="cmc_icon-up" aria-hidden="true"></i>';
                $change_class_24h = 'cmc-up';
                $change_sign_ath = '<i class="cmc_icon-up" aria-hidden="true"></i>';
                $change_class_ath = 'cmc-up';
                if (strpos($coin['percent_change_24h'], $change_sign_minus) !== false) {
                    $change_sign_24h = '<i class="cmc_icon-down" aria-hidden="true"></i>';
                    $change_class_24h = 'cmc-down';
                }
                if (isset($coin['ath_change_percentage']) && strpos($coin['ath_change_percentage'], $change_sign_minus) !== false) {
                    $change_sign_ath = '<i class="cmc_icon-down" aria-hidden="true"></i>';
                    $change_class_ath = 'cmc-down';
                }

                if (isset($coin['ath_change_percentage'])) {
                    $ath_change_percentage = $change_sign_ath . number_format((float)$coin['ath_change_percentage'], 2, '.', '') . '%';

                }
                $all_c_p_html = '';
                $live_updates_cls = "";
                if ($single_live_updates) {
                    $live_updates_cls = "cmc_live_updates";
                }
                $coin_logo = cmc_coin_single_logo($coin_id);
                $coin_price_html = '';
                $coin_ath_html = '';
                $coin_high_html = '';
                $coin_low_html = '';
                $current_currency = ($old_currency == "BTC") ? $btc_price : $fiat_c_rate;
                $coin_price_html .= '<span  data-coin-price="' . esc_attr($price) . '" class="cmc_coin_price coin-price">' . esc_html($currency_icon . $coin_price) . '</span>';
                $coin_ath_html .= '<span  data-coin-ath="' . esc_attr($coin_ath) . '" class="cmc_coin_ath coin-ath">' . esc_html($ath) . '</span>';
                $coin_high_html .= '<span  data-coin-high24="' . esc_attr($high_24h_val) . '" class="cmc_coin_high24 coin-high24">' . esc_html($high_24h) . '</span>';
                $coin_low_html .= '<span  data-coin-low24="' . esc_attr($low_24h_val) . '" class="cmc_coin_low24 coin-low24">' . esc_html($low_24h) . '</span>';
                $output .= '<div class="cmc_coin_details"><ul class="single_lU_wrp  ' . esc_attr($live_updates_cls) . '"
				data-trading-pair="' . esc_attr($coin_symbol) . 'USDT"
				data-currency-symbol="' . esc_attr($currency_symbol) . '"
				data-currency-rate="' . esc_attr($current_currency) . '" data-currency-name="' . esc_attr($old_currency) . '"
				 data-coin-symbol="' . esc_attr($coin_symbol) . '"  data-coin-id="' . esc_attr($coin_id) . '" data-coin-price="' . esc_attr($coin['price']) . '">
			   <li><div class="ccpw_icon">' . $coin_logo . '</div>
			   <div class="coin-name"><strong>' . esc_html($coin_name) . ' (' . esc_html($coin_symbol) . ')</strong></div>
			   <div data-coin-id="' . esc_attr(strtolower($coin_id)) . '" class="btn_cmc_watch_list cmc-icon-fav-empty" data-watch-title="' . __('Add to watch list', 'cmc') . '" data-unwatch-title="' . __('Remove from watch list', 'cmc') . '"></div>
	           </li>
	          <li class="c_info pri"><strong>' . __('Live Price ', 'cmc') . '</strong> <div class="chart_coin_price CCP-' . esc_attr($coin_symbol) . '">' . $coin_price_html . '</div></li>';
                if ($this->cmc_single_page_setting("display_changes24h_single")) {
                    $output .= '<li  class="cmc_changes">
					<strong>' . __('24h % ', 'cmc') . '</strong>
					<div class="cmc_coin_price_change cmc-24h-changes" ><span class="' . esc_attr($change_class_24h) . '">' . $change_sign_24h . esc_html($percent_change_24h) . '</span></div></li>';
                }

                if ($this->cmc_single_page_setting("display_market_cap_single")) {
                    $output .= '<li  class="c_info cap"><strong>' . __('Market Cap', 'cmc') . '</strong> <div class="coin_market_cap"><span class="CCMC">' . esc_html($market_cap) . '</span></div></li>';
                }
                if ($this->cmc_single_page_setting("display_Volume_24h_single")) {
                    $output .= ' <li  class="cmc_info vol"><strong>' . __('Volume', 'cmc') . '</strong> <div class="cmc_coin_volume" ><span class="CCV-' . esc_attr($coin_symbol) . '">' . esc_html($currency_icon . $volume) . '</span></div></li>';
                }
                if ($this->cmc_single_page_setting("display_ath_single") && isset($coin['ath'])) {
                    $output .= ' <li  class="cmc_info ath"><strong>' . __('ATH', 'cmc') . '</strong> <div class="cmc_coin_volume" ><span class="cmc-ath">' . $coin_ath_html . '</span></div></li>';
                }
                if ($this->cmc_single_page_setting("ath_change_percentage_single") && $ath_change_percentage) {
                    $output .= ' <li  class="cmc_info percentage"><strong>' . __('ATH(% Change)', 'cmc') . '</strong> <div class="cmc_coin_ath_per" ><span class="' . esc_attr($change_class_ath) . '">' . $ath_change_percentage . '</span></div></li>';
                }
                if ($this->cmc_single_page_setting("ath_date_single") && $ath_date) {
                    $output .= ' <li  class="cmc_info date"><strong>' . __('ATH Date', 'cmc') . '</strong> <div class="cmc_coin_ath_date" ><span class="cmc-ath-date">' . esc_html($ath_date) . '</span></div></li>';
                }
                if ($this->cmc_single_page_setting("display_high_24h_single")) {
                    $output .= ' <li  class="cmc_info ath"><strong>' . __('High 24H', 'cmc') . '</strong> <div class="cmc_coin_volume" ><span class="cmc-ath-high">' . $coin_high_html . '</span></div></li>';
                    $output .= ' <li  class="cmc_info high"><strong>' . __('Low 24H', 'cmc') . '</strong> <div class="cmc_coin_high" ><span class="cmc-ath-low">' . $coin_low_html . '</span></div></li>';
                }
                //    if($this->cmc_single_page_setting("display_low_24h_single")){
                //     $output.=' <li  class="cmc_info high"><strong>'.__('Low 24H','cmc').'</strong> <div class="cmc_coin_high" ><span class="cmc-ath-low">'.$coin_low_html.'</span></div></li>';
                //    }
                if ($this->cmc_single_page_setting("display_supply_single")) {
                    $coin_symbol = $available_supply == 'N/A' ? '' : $coin_symbol;
                    $output .= '<li  class="cmc_info sup"><strong>' . __('Available Supply', 'cmc') . '</strong> <div class="cmc_coin_supply"><span class="CCS-' . esc_attr($coin_symbol) . '">' . esc_html($available_supply) . '</span> <span class="coin-symbol">' . esc_html($coin_symbol) . '</span></div></li>';
                }
                $output .= '<li  class="cmc_info rank"><strong>' . __('Rank', 'cmc') . '</strong> <div class="cmc_rank_badge"><span class="CCS-' . esc_attr($coin_symbol) . '">' . esc_html($rank) . '</span></div></li>';
                //$output.='<li class="cmc_rank_badge">'.__('Rank:','cmc').$coin['rank'].'</li>';

                $output .= '</ul></div>';

            } else {
                return __('Currency Not Found', 'cmc');
            }
        } else {
            return __('Something wrong with URL', 'cmc');
        }

        return $output;

    }

/*
|--------------------------------------------------------------------------
| Coin historical data datatable shortcode
| Shortcode:-[cmc-history]
|--------------------------------------------------------------------------
 */

    public function cmc_historical_data($atts, $content = null)
    {
        // shortcode
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';
        //Initialize Titan

        $real_cur = get_query_var('currency');
        $single_default_currency = cmc_get_option('default_currency');
        $enable_formatting = cmc_get_option('s_enable_formatting');
        $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
        //$selected_currency_rate = cmc_usd_conversions($old_currency);
        //$currency_symbol = cmc_old_cur_symbol($old_currency);
        if (get_query_var('coin_id')) {
            $coin_id = trim(get_query_var('coin_id'));
            if ($coin_id == "MIOTA") {
                $coin_id = 'IOT';
            } else if ($coin_id == "BTX") {
                $coin_id = 'BTX2';
            } else if ($coin_id == '0xBTC') {
                $coin_id = '0XBTC';
            }

            $cmc_prev = __('Previous', 'cmc');
            $cmc_next = __('Next', 'cmc');
            $cmc_show = __('Show', 'cmc');
            $cmc_entries = __('Entries', 'cmc');
            $no_data = __('No Historical Data Available', 'cmc');
            $cmc_show_entries = sprintf("%s _MENU_ %s", $cmc_show, $cmc_entries);
            $output .= '<div class="cmc-coin-historical-data">

	<table  id="cmc_historical_tbl" data-number-formating="' . esc_attr($enable_formatting) . '"
	class="display table table-striped table-bordered" data-no-data-lbl="' . esc_attr($no_data) . '"
   data-per-page="10" data-show-entries="' . esc_attr($cmc_show_entries) . '" data-prev="' . esc_attr($cmc_prev) . '" data-next="' . esc_attr($cmc_next) . '"
	data-coin-id="' . esc_attr($coin_id) . '" data-currency-symbol="$">
	<thead><tr>
	<th data-classes="cmc_h_date"  data-index="date">' . __('Date', 'cmc') . '</th>
	<th data-classes="cmc_h_price" data-index="value">' . __('Price', 'cmc') . '</th>
	<th data-classes="cmc_h_volume" data-index="volume">' . __('Volume', 'cmc') . '</th>
	<th data-classes="cmc_h_marketcap" data-index="market_cap">' . __('MarketCap', 'cmc') . '</th>
	</tr></thead><tbody>';
            $output .= '</tbody>
	</table></div>';
        } else {
            return '<b>' . __('Something Wrong With URL', 'cmc') . '</b>';
        }

        return $output;
    }

/*
|--------------------------------------------------------------------------
| Coin Full Chart shortcode callback
| Shortcode:-[cmc-chart]
|--------------------------------------------------------------------------
 */
    public function cmc_chart_shortcode($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';

        if (get_query_var('coin_id')) {
            $single_default_currency = cmc_get_option('default_currency');
            $coin_symbol = sanitize_text_field(get_query_var('coin_symbol')) ?: 'BTC';
            $coin_id = sanitize_text_field(trim(get_query_var('coin_id'))) ?: 'Bitcoin';
            $real_cur = sanitize_text_field(get_query_var('currency')); // Sanitize currency
            $old_currency = trim($real_cur) !== "" ? trim($real_cur) : $single_default_currency;
            // $api_obj=new CMC_api_data();
            $fiat_c_rate = CMC_api_data::cmc_usd_conversions($old_currency);
            $currentVol = '';
            $currentPrice = '';
            $query = array('post_type' => 'cmc-description', 'meta_value' => $coin_id);
            $the_query = new WP_Query($query);
            $trading_chart = '';
            // This code is used to fetch trading viewcode
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    $cmcd_id = get_the_ID();
                    $trading_chart = get_post_meta($cmcd_id, 'cmc_single_settings_trading_chart', true);
                    $trading_chart_code = get_post_meta($cmcd_id, 'cmc_single_settings_trading_chart_code', true);
                    $trading_chart_code = !empty($trading_chart_code) ? $trading_chart_code : "<b>Please Enter Trading View Chart Script</b>";

                }
            }
            // If trading chart setting is enable then default chart is not display
            if ($trading_chart == 'on') {
                $output .= '<div class="cmc-chart" data-tradingview_chart="' . esc_attr($trading_chart) . '">' . $trading_chart_code . '</div>';
                return $output;
            }

            //grabing data from DB
            $coin = cmc_get_coin_details($coin_id);
            if ($coin) {
                $currentVol = $coin['total_volume'];
                $currentPrice = $coin['price'];
            }

            $chart_height = '100%';
            $coin_released = '365day';

            if ($coin_symbol == "MIOTA") {
                $coin_symbol = 'IOT';
            } else if ($coin_symbol == "BTX") {
                $coin_symbol = 'BTX2';
            } else if ($coin_symbol == '0xBTC') {
                $coin_symbol = '0XBTC';
            }
            $no_formatting = '';
            $decimalPlaces = ($currentPrice < 1) ? strlen(substr(strrchr($currentPrice, "."), 1)) : 3;
            $no_formatting = "'$'#." . str_repeat('#', $decimalPlaces);

            $c_color = cmc_get_option('chart_color');
            $c_bg_color = cmc_get_option('chart_bg_color');
            //    var_dump($c_bg_color);
            if (isset($c_color) && !empty($c_color)) {
                $chart_color = $c_color;
            } else {
                $chart_color = "#8BBEED";
            }
            if (isset($c_bg_color) && !empty($c_bg_color)) {
                $chart_bg_color = $c_bg_color;
            } else {
                $chart_bg_color = "#8BBEED";
            }
            $chart_from = __('From', 'cmc');
            $data_1D = __('24H', 'cmc');
            $data_7D = __('7D', 'cmc');
            $data_1M = __('1M', 'cmc');
            $data_3M = __('3M', 'cmc');
            $data_6M = __('6M', 'cmc');
            $data_1Y = __('1Y', 'cmc');
            $chart_to = __('To', 'cmc');
            $chart_zoom = __('Zoom', 'cmc');
            $chart_price = __('Price', 'cmc');
            $chart_volume = __('Volume', 'cmc');
            $output .= '<span class="cmc-am4-range"></span>';
            $output .= '<div class="cmc-chart" data-no-formatting="' . esc_attr($no_formatting) . '"  data-coin-current-price="' . esc_attr($currentPrice) . '" data-coin-current-vol="' . esc_attr($currentVol) . '" data-fiat-c-rate="' . esc_attr($fiat_c_rate) . '" data-coin-period="' . esc_attr($coin_released) . '" data-coin-id="' . esc_attr($coin_id) . '"
		data-chart-color="' . esc_attr($chart_color) . '" data-chart-bg-color="' . esc_attr($chart_bg_color) . '"data-chart-from="' . esc_attr($chart_from) . '" data-chart-to="' . esc_attr($chart_to) . '"
		data-chart-zoom="' . esc_attr($chart_zoom) . '" data-chart-price="' . esc_attr($chart_price) . '" data-chart-volume="' . esc_attr($chart_volume) . '"
			data-1d="' . esc_attr($data_1D) . '" data-7d="' . esc_attr($data_7D) . '" data-1m="' . esc_attr($data_1M) . '" data-3m="' . esc_attr($data_3M) . '"
            data-6m="' . esc_attr($data_6M) . '" data-1y="' . esc_attr($data_1Y) . '">';
            $output .= '<div id="cmc-chart-preloader"><img class="cmc-preloader" src="' . CMC_URL . 'images/chart-loading.svg"><br/>' . __('<b> Loading Data </b> <br>Please wait, we are loading chart data', 'cmc') . '</div>';
            $output .= '<div style="display:none" id="cmc-no-data">' . __('No Graphical Data', 'cmc') . '</div>';
            $output .= '<div class="cmc-wrp"  id="CMC-CHART-' . esc_attr($coin_id) . '" style="width:100%; height:' . esc_attr($chart_height) . ';" >
		</div></div>';

        }
        return $output;
    }

/*
|--------------------------------------------------------------------------
| Coin twitter feed handler shortcode
| Shortcode:-[cmc-twitter-feed]
|--------------------------------------------------------------------------
 */
    public function cmc_twitter_feed()
    {

        $tweet_option = cmc_get_option('twitter_feed_display');
        $tweet_option = ($tweet_option == false) ? "yes" : $tweet_option;

        if ($tweet_option == "yes" && get_query_var('coin_id')) {

            $twitter_feed_type = cmc_get_option('twitter_feed_type');
            $coin_id = !empty(trim(get_query_var('coin_id'))) ? (string) trim(get_query_var('coin_id')) : 'Bitcoin';
            $coin_symbol = !empty(get_query_var('coin_symbol')) ? get_query_var('coin_symbol') : 'BTC';

            // The Query
            $query = array('post_type' => 'cmc-description', 'meta_value' => $coin_id);
            $the_query = new WP_Query($query);
            $twitter_name = '';
            $coin_twt_name = '';
            // The Loop
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    $cmcd_id = get_the_ID();
                    $coin_twt_name = get_post_meta($cmcd_id, 'cmc_single_settings_coin_twt', true);
                    if ($coin_twt_name != '') {
                        $twitter_name = $coin_twt_name;
                    }
                }
            }
            $coin_data = cmc_get_coin_meta($coin_id);
            if ($twitter_name == '') {
                if (isset($coin_data['twitter']) && $coin_data['twitter'] != "N/A") {
                    $twitter_name = $coin_data['twitter'];
                }
            }

            /* Restore original Post Data*/
            wp_reset_postdata();
            if (isset($twitter_name) && !empty($twitter_name)) {
                wp_enqueue_script('cmc-twitter-widget');
                $output = '<a class="twitter-timeline" href="' . esc_url($twitter_name) . '?ref_src=twsrc%5Etfw"></a>';
                return $output;
            } else {
                return false;
            }

        }
    }

/*
|--------------------------------------------------------------------------
| Coin links shortcode handler
| Shortcode:- [cmc-coin-extra-data]
|--------------------------------------------------------------------------
 */

    public function cmc_coin_extra_data($coin_id)
    {

        if (get_query_var('coin_id')) {
            $coin_id = (string) trim(get_query_var('coin_id'));
            $coin_symbol = (string) trim(get_query_var('coin_symbol'));
            $coin_data = cmc_get_coin_meta($coin_id);

            // The Query
            $query = array('post_type' => 'cmc-description', 'meta_value' => $coin_id);
            $the_query = new WP_Query($query);
            // The Loop
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    $cmcd_id = get_the_ID();
                    $coin_be = get_post_meta($cmcd_id, 'cmc_single_settings_coin_be', true);
                    $coin_ow = get_post_meta($cmcd_id, 'cmc_single_settings_coin_ow', true);
                    $coin_wp = get_post_meta($cmcd_id, 'cmc_single_settings_coin_wp', true);
                    $coin_yt = get_post_meta($cmcd_id, 'cmc_single_settings_coin_yt', true);
                    $coin_rd = get_post_meta($cmcd_id, 'cmc_single_settings_coin_rd', true);

                    $coin_gh = get_post_meta($cmcd_id, 'cmc_single_settings_coin_gh', true);
                    $coin_fb = get_post_meta($cmcd_id, 'cmc_single_settings_coin_fb', true);

                    $coin_twt = get_post_meta($cmcd_id, 'cmc_single_settings_coin_twt', true);
                    $coin_redt = get_post_meta($cmcd_id, 'cmc_single_settings_coin_redt', true);

                }
                /* Restore original Post Data*/
                wp_reset_postdata();

                if (isset($coin_be) && !empty($coin_be)) {
                    $block_explorer = $coin_be;
                } else {
                    $block_explorer = isset($coin_data['block_explorer']) ? $coin_data['block_explorer'] : null;
                }
                if (isset($coin_ow) && !empty($coin_ow)) {
                    $website = $coin_ow;
                } else {
                    $website = isset($coin_data['website']) ? $coin_data['website'] : "";
                }
                if (isset($coin_wp) && !empty($coin_wp)) {
                    $whitepaper = $coin_wp;
                } else {
                    $whitepaper = isset($coin_data['whitepaper']) ? $coin_data['whitepaper'] : null;
                }
                if (isset($coin_yt) && !empty($coin_yt)) {
                    $youtube = $coin_yt;
                } else {
                    $youtube = isset($coin_data['youtube']) ? $coin_data['youtube'] : null;
                }
                if (isset($coin_rd) && !empty($coin_rd)) {
                    $announced = $coin_rd;
                } else {
                    $announced = isset($coin_data['announced']) ? $coin_data['announced'] : null;
                }
                if (isset($coin_fb) && !empty($coin_fb)) {
                    $facebook = $coin_fb;
                } else {
                    $facebook = isset($coin_data['facebook']) ? $coin_data['facebook'] : null;
                }
                if (isset($coin_gh) && !empty($coin_gh)) {
                    $github = $coin_gh;
                } else {
                    $github = isset($coin_data['github']) ? $coin_data['github'] : null;
                }

                if (isset($coin_twt) && !empty($coin_twt)) {
                    $twitter = $coin_twt;
                } else {
                    $twitter = isset($coin_data['twitter']) ? $coin_data['twitter'] : null;
                }
                if (isset($coin_redt) && !empty($coin_redt)) {
                    $reddit = $coin_redt;
                } else {
                    $reddit = isset($coin_data['reddit']) ? $coin_data['reddit'] : null;
                }

            } else {
                if (is_array($coin_data) && !empty($coin_data)) {
                    extract($coin_data, EXTR_PREFIX_SAME, "dup");
                }
            }
            $output = '';
            $output .= '<div class="cmc-extra-info"><ul>';

            if (isset($block_explorer) && $block_explorer != "N/A") {
                $output .= '<a class="blockexplorer" target="_blank" href="' . esc_url($block_explorer) . '" rel="nofollow" title="Block Explorer"><li>' . __('Block', 'cmc') . '<br/>' . __('Explorer', 'cmc') . '</li></a>';
            };
            if (isset($website) && $website != "N/A") {
                $output .= '<a class="website" target="_blank"  href="' . esc_url($website) . '" rel="nofollow" title="Official Website"><li>' . __('Official', 'cmc') . '<br/>' . __('Website', 'cmc') . '</li></a>';
            };
            if (isset($whitepaper) && $whitepaper != "N/A") {
                $output .= '<a class="whitepaper" target="_blank" href="' . esc_url($whitepaper) . '" rel="nofollow" title="Coin Whitepaper"><li>' . __('White', 'cmc') . '<br/>' . __('Paper', 'cmc') . '</li></a>';
            };
            if (isset($youtube) && $youtube != "N/A") {
                $output .= '<a class="youtube" target="_blank" href="' . esc_url($youtube) . '" rel="nofollow" title="Official Youtube"><li>' . esc_html($coin_symbol) . '<br/>' . __('YouTube', 'cmc') . '</li></a>';
            };
            if (isset($announced) && $announced != "N/A") {
                $output .= '<a class="firstannounced" title="First Announced / Published"><li>' . esc_html($announced) . '</li></a>';
            };
            if (isset($github) && $github != "N/A") {
                $output .= '<a class="github" target="_blank" href="' . esc_url($github) . '" rel="nofollow" title="Github"><li>' . esc_html($coin_symbol) . '<br/>' . __('Github', 'cmc') . '</li></a>';
            };
            if (isset($reddit) && $reddit != "N/A") {
                $url = (strpos($reddit, 'reddit.com') > 0) ? $reddit : 'https://www.reddit.com/r/' . $reddit;
                $redit_url = $url;
                $output .= '<a class="reddit" target="_blank" href="' . esc_url($redit_url) . '" rel="nofollow" title="Reddit"><li>' . esc_html($coin_symbol) . '<br/>' . __('Reddit', 'cmc') . '</li></a>';
            };
            if (isset($twitter) && $twitter != "N/A") {
                $output .= '<a class="twitter" target="_blank" href="' . esc_url($twitter) . '" rel="nofollow" title="Twitter"><li>' . esc_html($coin_symbol) . '<br/>' . __('Twitter', 'cmc') . '</li></a>';
            };
            if (isset($facebook) && $facebook != "N/A") {
                $output .= '<a class="facebook" target="_blank" href="' . esc_url($facebook) . '" rel="nofollow" title="Facebook"><li>' . esc_html($coin_symbol) . '<br/>' . __('Facebook', 'cmc') . '</li></a>';
            };

            $output .= '</ul>
		</div>';
            return $output;

        }
    }

/*
|--------------------------------------------------------------------------
| TITAN FRAMEWORK SINGLE PAGE SETTINGS
|--------------------------------------------------------------------------
 */

    public function cmc_single_page_setting($settingKey)
    {

        $settings = cmc_get_option($settingKey);
        if ($settings) {
            return true;
        } else {
            return false;
        }
    }

/*
|--------------------------------------------------------------------------
| Registering all assets for coin single page
|--------------------------------------------------------------------------
 */
    // common assets for all shortcodes
    public function cmc_single_assets()
    {global $wp_version;
        wp_register_script('cmc-readmore-option', CMC_URL . 'assets/js/read_more.js', array('jquery'), CMC, true);
        wp_register_script('cmc-twitter-widget', CMC_URL . 'assets/js/libs/twitter-widget.js', array('jquery'), CMC, true);

        wp_register_script('cmc-datatables', CMC_URL . 'assets/js/libs/jquery.dataTables.min.js', array('jquery'), CMC, true);
        wp_register_script('cmc-custom-fixed-col', CMC_URL . 'assets/js/libs/tableHeadFixer.js', array('jquery', 'cmc-datatables'), CMC, true);
        wp_register_script('cmc-single-js', CMC_URL . 'assets/js/single/cmc-basic-single.js', array('jquery', 'cmc-datatables'), CMC, true);
        //    wp_register_script('cmc-historical-tbl', CMC_URL . 'assets/js/cmc-historical-tbl.js', array('jquery','cmc-datatables'), false, true);
        wp_register_script('ccpw-lscache', CMC_URL . 'assets/js/libs/lscache.min.js', array('jquery'), CMC, true);
        wp_register_script('crypto-numeral', CMC_URL . 'assets/js/libs/numeral.min.js', array('jquery'), CMC, true);

        wp_register_style('cmc-custom', CMC_URL . 'assets/css/cmc-custom.css', null, CMC);

        if (cmc_get_option('single_page_title') == "yes") {
            $dynamic_css = ".cmc-single-page .entry-title,.cmc-single-page h1.cmc-dynamic-title{display:none}";
            wp_add_inline_style('cmc-custom', $dynamic_css);
        }

        $single_page_id = get_option('cmc-coin-single-page-id');
        if (is_page($single_page_id)) {
            /**
             * Am4 chart library
             */
            if (version_compare($wp_version, '6.3', '>=')) {
                wp_enqueue_script('cmc-amcharts-core-js', CMC_URL . 'assets/js/amcharts/cmc-core.js', array(), CMC, array('strategy' => 'defer'), true);
                wp_enqueue_script('cmc-amstock-js', CMC_URL . 'assets/js/amcharts/charts.js', array(), CMC, array('strategy' => 'defer'), true);
                wp_enqueue_script('cmc-range-selecetor', CMC_URL . 'assets/js/amcharts/range-selector.js', array(), CMC, array('strategy' => 'defer'), true);
                wp_enqueue_script('cmc-theme-animated', CMC_URL . 'assets/js/amcharts/animated.js', array(), CMC, array('strategy' => 'defer'), true);
            } else {
                wp_enqueue_script('cmc-amcharts-core-js', CMC_URL . 'assets/js/amcharts/cmc-core.js', array(), CMC, true);
                wp_enqueue_script('cmc-amstock-js', CMC_URL . 'assets/js/amcharts/charts.js', array(), CMC, true);
                wp_enqueue_script('cmc-range-selecetor', CMC_URL . 'assets/js/amcharts/range-selector.js', array(), CMC, true);
                wp_enqueue_script('cmc-theme-animated', CMC_URL . 'assets/js/amcharts/animated.js', array(), CMC, true);
            }

            wp_enqueue_style('cmc-bootstrap');
            wp_enqueue_style('cmc-custom');
            wp_enqueue_script('crypto-numeral');
            wp_enqueue_script('cmc-datatables');
            wp_enqueue_script('cmc-custom-fixed-col');
            $single_live_updates = cmc_get_option('single_live_updates');
            $binance_url = cmc_get_option('cmc_single_binance_url');
            

            if ($single_live_updates) {
                wp_enqueue_script('ccc-binance-socket', CMC_URL . 'assets/js/socket/binance.min.js', array('jquery'), CMC, true);
                wp_enqueue_script('ccc_stream', CMC_URL . 'assets/js/socket/cmc-stream.js', null, CMC, true);
                wp_localize_script('ccc_stream', 'cmc_settings', array('binance_url' => $binance_url));
            }
            $api_option = get_option("openexchange-api-settings");
            $api_type = (isset($api_option['select_api'])) ? $api_option['select_api'] : "coingecko";
            wp_enqueue_script('ccpw-lscache');
            wp_enqueue_script('cmc-single-js');
            wp_localize_script(
                'cmc-single-js',
                'data_object',
                array('ajax_url' => admin_url('admin-ajax.php'),
                    'nonce' => wp_create_nonce('wp_rest'),
                    'enable_7day_chart' => ($api_type == "coinmarketcap" || $api_type == "both_coinmarketcap") ? 'on' : cmc_get_option('enable_7day_chart'),
                )
            );

        }}

/*
|--------------------------------------------------------------------------
| Facebook Comment Box Shortcode Handlers
| Shortcode:-[coin-market-cap-comments]
|--------------------------------------------------------------------------
|
 */

    public function cmc_comment_box($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';
        global $wp;
        $page_url = home_url($wp->request, '/');

        global $post;
        $page_id = $post->ID;
        $single_page_id = get_option('cmc-coin-single-page-id');

        if (is_page($page_id) && $page_id == $single_page_id || is_page('cmc-currency-details')) {
            $disqu_app_id = cmc_get_option("cmc_disqu_app_Id");
            if (isset($disqu_app_id) && !empty($disqu_app_id)) {
                $app_id = $disqu_app_id ? $disqu_app_id : 'httplocalhostwordpress11demo';
                $output .= ' <div id="disqus_thread"></div>
                    <script>
                    (function() {
                        var d = document, s = d.createElement("script");
                        s.src = "https://' . $app_id . '.disqus.com/embed.js";
                        s.setAttribute("data-timestamp", +new Date());
                        (d.head || d.body).appendChild(s);
                    })();
                    </script>
                   <noscript>Please enable JavaScript to view the <a href="https://disqus.com/?ref_noscript">comments powered by Disqus.</a></noscript>';
            }

        }

        return $output;
    }

/*
|--------------------------------------------------------------------------
| extracting screen name from twitter url
|--------------------------------------------------------------------------
 */
    public function cmc_get_twitter_id_from_url($url)
    {
        if (preg_match("/^https?:\/\/(www\.)?twitter\.com\/(#!\/)?(?<name>[^\/]+)(\/\w+)*$/", $url, $regs)) {
            return $regs['name'];
        }
        return false;
    }

/*
|--------------------------------------------------------------------------
| coin affiliate links
|--------------------------------------------------------------------------
 */
    public function cmc_affiliate_links($atts, $content = null)
    {
        $atts = shortcode_atts(array(
            'id' => '',
        ), $atts);
        $output = '';
        if (get_query_var('coin_id')) {
            $coin_id = ucfirst(get_query_var('coin_id'));
            $query = array('post_type' => 'cmc-description', 'meta_value' => $coin_id);
            $the_query = new WP_Query($query);
            $twitter_name = '';
            $coin_buy_sell_name = '';
            $buy_link = '';
            $buy_affiliate_link = "#";
            $sell_affiliate_link = "#";
            // The Loop
            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) {
                    $the_query->the_post();
                    $cmcd_id = get_the_ID();
                    $coin_buy_sell_name = get_post_meta($cmcd_id, 'cmc_single_settings_buy_sell_link', true);
                }
            }
            $coin_symbol = ucfirst(get_query_var('coin_symbol'));
            $real_currency = get_query_var('currency');
            $real_currency = !empty($real_currency) ? strtolower(trim($real_currency)) : 'usd';
            $coin_name = ucwords(str_replace('-', ' ', get_query_var('coin_id')));
            $affiliate_type = cmc_get_option('choose_affiliate_type');
            if ($coin_buy_sell_name != '') {
                $buy_affiliate_link = $coin_buy_sell_name;
            } else {
                if ($affiliate_type == "changelly_aff_id") {
                    $affiliate_id = '';
                    $affiliate_id = !empty(cmc_get_option('affiliate_id')) ? cmc_get_option('affiliate_id') : '675b2e20174f';
                    $buy_affiliate_link = sprintf('https://changelly.com/buy-crypto?from=%s&to=%s&amount=1&ref_id=%s', $real_currency, strtolower($coin_symbol), $affiliate_id);
                    $sell_affiliate_link = sprintf('https://changelly.com/exchange/%s/BTC/1?ref_id=%s', $coin_symbol, $affiliate_id);
                }
                if (!empty(cmc_get_option('other_affiliate_link'))) {
                    $other_affiliate_link = cmc_get_option('other_affiliate_link');
                    if ($other_affiliate_link) {
                        $buy_affiliate_link = $other_affiliate_link;
                        $sell_affiliate_link = $other_affiliate_link;
                    }
                }
            }
            if (!empty($buy_affiliate_link)) {
                $output = '<span class="cmc_affiliate_links">
		<a target="_blank" class="cmc_buy" href="' . esc_url($buy_affiliate_link) . '"><i class="cmc_icon-buy-coin" aria-hidden="true"></i> ' . __('Buy / Sell', 'cmc') . ' ' . esc_html($coin_name) . '</a>
		</span>';
            }

            /*
        <a target="_blank" class="cmc_sell" href="' . $sell_affiliate_link . '"><i class="cmc_icon-sell-coin" aria-hidden="true"></i>' . __('Sell', 'cmc') . ' ' . $coin_name . '</a>
         */

        }
        return $output;

    }

}
